<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Availability extends Model
{
    protected $table = 'availability';
    protected $primaryKey = 'availability_id';
    public $timestamps = true;

    protected $fillable = [
        'profile_id',
        'availability',
        'timezone',
    ];

    protected $casts = [
        'availability' => 'array', // Cast to array for JSON storage
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    public function candidateProfile()
    {
        return $this->belongsTo(CandidateProfile::class, 'profile_id', 'Profile_id');
    }
}
